/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.upgrades.heal;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;
import xyz.przemyk.simpleplanes.setup.SimplePlanesUpgrades;
import xyz.przemyk.simpleplanes.upgrades.Upgrade;
import xyz.przemyk.simpleplanes.upgrades.UpgradeType;

public class HealingUpgrade
extends Upgrade {
    private int cooldown = 10;

    public HealingUpgrade(PlaneEntity planeEntity) {
        super((UpgradeType)SimplePlanesUpgrades.HEALING.get(), planeEntity);
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compoundNBT = new CompoundNBT();
        compoundNBT.func_74768_a("cooldown", this.cooldown);
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundNBT compoundNBT) {
        this.cooldown = compoundNBT.func_74762_e("cooldown");
    }

    @Override
    public void tick() {
        if (this.cooldown > 0) {
            --this.cooldown;
        } else {
            this.remove();
        }
    }

    @Override
    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float partialTicks) {
    }

    @Override
    public void onApply(ItemStack itemStack, PlayerEntity playerEntity) {
        int m;
        int health = this.planeEntity.getHealth();
        if (health < (m = this.planeEntity.getMaxHealth() * 2)) {
            int heal = this.planeEntity.getOnGround() ? 2 : 1;
            this.planeEntity.setHealth(Math.min(health + heal, m));
        }
        this.planeEntity.goldenHeartsTimeout = 0;
    }

    @Override
    public void writePacket(PacketBuffer buffer) {
    }

    @Override
    public void readPacket(PacketBuffer buffer) {
    }

    @Override
    public void dropItems() {
    }
}

